// ThreadsInfo.cpp : Defines the entry point for the console application.
//
#pragma comment( lib, "psapi" )

#include "stdafx.h"
#include <windows.h>
#include <Psapi.h>
#include <tlhelp32.h>

// https://docs.microsoft.com/en-us/windows/win32/toolhelp/traversing-the-thread-list

BOOL ShowProcessNameForThread(DWORD pid);

int main()
{
	
	DWORD dwThreadCount = 0;

	HANDLE hThreadSnap = INVALID_HANDLE_VALUE;
	THREADENTRY32 te32;

	hThreadSnap = CreateToolhelp32Snapshot(TH32CS_SNAPTHREAD, 0);
	if (hThreadSnap == INVALID_HANDLE_VALUE)
		return(0);

	te32.dwSize = sizeof(THREADENTRY32);

	if (!Thread32First(hThreadSnap, &te32))
	{
		CloseHandle(hThreadSnap);     // Must clean up the snapshot object!
		return(0);
	}

	do
	{
		dwThreadCount++;
		printf("THREAD ID = 0x%08X (base priority  = %d | delta priority = %d)", te32.th32ThreadID, te32.tpBasePri, te32.tpDeltaPri);
		ShowProcessNameForThread(te32.th32OwnerProcessID);
		printf("\n");
	} while (Thread32Next(hThreadSnap, &te32));

	CloseHandle(hThreadSnap);
	printf("\n\n\t Count %d thereads.", dwThreadCount);
	return dwThreadCount;
}

BOOL ShowProcessNameForThread(DWORD pid)
{
	wchar_t szProcessName[MAX_PATH] = L"<unknown>";

	HANDLE hProcess = OpenProcess(PROCESS_QUERY_INFORMATION | PROCESS_VM_READ, FALSE, pid);
	if (hProcess != NULL)
	{
		if (GetModuleFileNameEx(hProcess, NULL, szProcessName, sizeof(wchar_t) * MAX_PATH / sizeof(wchar_t)) != 0)
		{
			printf(" Name: %ws (%d)", szProcessName, pid);
			
			CloseHandle(hProcess);
			return TRUE;
		}
		else
		{
			printf(" PiD: %d", pid);
			CloseHandle(hProcess);
			return FALSE;
		}
		
	}
	else
		printf(" PiD: %d", pid);
	
	return FALSE;
}
